using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hiveAdiz
{
	public class AdizConsentManager
	{
		
	#if UNITY_ANDROID && !UNITY_EDITOR

		private static AndroidJavaObject currentActivity = null;
		private static AndroidJavaClass hiveAdizPlugin = new AndroidJavaClass("com.hive.adiz.plugin.consent.AdizUnityConsentManager"); 

		public static void ShowPrivacyOptionsForm(CommonHandlers handler) {
			AdizLogger.d("AdizConsentManager ShowPrivacyOptionsForm");
			
			AndroidJavaClass jc = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
			currentActivity = jc.GetStatic<AndroidJavaObject>("currentActivity");

			hiveAdizPlugin.CallStatic("showPrivacyOptionsForm", currentActivity);

			AdizCallbackManager.commonResultHandler = handler;
		}

		public static bool IsPrivacyOptionsRequired() {
			AdizLogger.d("AdizConsentManager IsPrivacyOptionsRequired");

			return hiveAdizPlugin.CallStatic<bool>("isPrivacyOptionsRequired");
		}

		public static void SetUserPrivacySettings(PrivacySettings settings) {
			AdizLogger.d("AdizConsentManager SetUserPrivacySettings");
			
			bool isUnderAgeForGDPR = settings.isTagForUnderAgeOfConsent;
			bool isChildDirectedTreatmentForCOPPA = settings.isTagForChildDirectedTreatment;
			
			hiveAdizPlugin.CallStatic("setUserPrivacySettings", isUnderAgeForGDPR, isChildDirectedTreatmentForCOPPA);
		}

	#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void Adiz_ConsentManagerShowPrivacyOptionsForm(string callbackObject, string callbackFunction);

		[DllImport("__Internal")]
		private static extern bool Adiz_ConsentManagerIsPrivacyOptionsRequired();

		[DllImport("__Internal")]
		private static extern bool Adiz_ConsentManagerSetUserPrivacySettings(bool underAgeOfConsent, bool childDirectedTreatment);

		public static void ShowPrivacyOptionsForm(CommonHandlers handler) {
			AdizLogger.d("AdizConsentManager ShowPrivacyOptionsForm");
			AdizCallbackManager.commonResultHandler = handler;
			Adiz_ConsentManagerShowPrivacyOptionsForm("AdizCallbackManager", "onCommonResult");
		}

		public static bool IsPrivacyOptionsRequired() {
			AdizLogger.d("AdizConsentManager IsPrivacyOptionsRequired");

			return Adiz_ConsentManagerIsPrivacyOptionsRequired();
		}

		public static void SetUserPrivacySettings(PrivacySettings settings) {
			AdizLogger.d("AdizConsentManager SetUserPrivacySettings");

			bool isUnderAgeForGDPR = settings.isTagForUnderAgeOfConsent;
			bool isChildDirectedTreatmentForCOPPA = settings.isTagForChildDirectedTreatment;
			Adiz_ConsentManagerSetUserPrivacySettings(isUnderAgeForGDPR, isChildDirectedTreatmentForCOPPA);
		}

	#else

		public static void ShowPrivacyOptionsForm(CommonHandlers handler) {

		}

		public static bool IsPrivacyOptionsRequired() {
			return false;
		}

		public static void SetUserPrivacySettings(PrivacySettings settings) {
			AdizLogger.d("AdizConsentManager SetUserPrivacySettings");
		}
		
	#endif
		
	}
}